# This program demonstrates the use of dictionaries to associate a college
# course with a room number, a instructor, and a start time.
def main():
    # Dictionary associating the course with a room number
    room = {'CS101':'3004',
            'CS102':'4501',
            'CS103':'6755',
            'NT110':'1244',
            'CM241':'1411'}
    # Dictionary associating the course with an instructor
    instructor = {'CS101':'Haynes',
                  'CS102':'Alvarado',
                  'CS103':'Rich',
                  'NT110':'Burke',
                  'CM241':'Lee'}
    # Dictionary associating the course with a start time
    time = {'CS101':'8:00 a.m.',
            'CS102':'9:00 a.m.',
            'CS103':'10:00 a.m.',
            'NT110':'11:00 a.m.',
            'CM241':'1:00 p.m.'}

    # Let's find out what course the user is interested in
    course = input("What course would you like? ")

    # We can use exception handling to avoid crashing the program
    # if the course doesn't exist
    try:
        # If the course does exist, we'll print out the course information
        print("Room:",room[course],
              "\nInstructor:",instructor[course],
              "\nTime:",time[course])
    # If we run into an error, we can handle that gracefully instead of crashing
    except KeyError:
        print("I'm sorry, but we couldn't find your course.")

if __name__=='__main__':
    main()
